/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.GreenManaAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class YedoraGraveGardenerContinuousEffect
extends ContinuousEffectImpl {
    YedoraGraveGardenerContinuousEffect() {
        super(Duration.Custom, Layer.CopyEffects_1, SubLayer.FaceDownEffects_1b, Outcome.Neutral);
    }

    private YedoraGraveGardenerContinuousEffect(YedoraGraveGardenerContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public YedoraGraveGardenerContinuousEffect copy() {
        return new YedoraGraveGardenerContinuousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target == null || !target.isFaceDown(game)) {
            this.discard();
            return false;
        }
        target.removeAllSuperTypes(game);
        target.removeAllCardTypes(game);
        target.removeAllSubTypes(game);
        target.addCardType(game, new CardType[]{CardType.LAND});
        target.addSubType(game, new SubType[]{SubType.FOREST});
        target.removeAllAbilities(source.getSourceId(), game);
        target.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
        return true;
    }
}

