/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class YennaRedtoothRegentEffect
extends OneShotEffect {
    YennaRedtoothRegentEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "choose target enchantment you control that doesn't have the same name as another permanent you control. Create a token that's a copy of it, except it isn't legendary. If the token is an Aura, untap {this}, then scry 2";
    }

    private YennaRedtoothRegentEffect(YennaRedtoothRegentEffect effect) {
        super((OneShotEffect)effect);
    }

    public YennaRedtoothRegentEffect copy() {
        return new YennaRedtoothRegentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        CreateTokenCopyTargetEffect create = new CreateTokenCopyTargetEffect().setPermanentModifier(token -> token.removeSuperType(SuperType.LEGENDARY));
        create.apply(game, source);
        if (create.getAddedPermanents().stream().noneMatch(t -> t != null && t.hasSubtype(SubType.AURA, game))) {
            return create.getAddedPermanents().size() > 0;
        }
        Permanent yenna = source.getSourcePermanentIfItStillExists(game);
        if (yenna != null) {
            yenna.untap(game);
        }
        if ((controller = game.getPlayer(source.getControllerId())) != null) {
            controller.scry(2, source, game);
        }
        return true;
    }
}

