/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class YennettCrypticSovereignEffect
extends OneShotEffect {
    YennettCrypticSovereignEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. You may cast it without paying its mana cost if its mana value is odd. If you don't cast it, draw a card.";
    }

    private YennettCrypticSovereignEffect(YennettCrypticSovereignEffect effect) {
        super((OneShotEffect)effect);
    }

    public YennettCrypticSovereignEffect copy() {
        return new YennettCrypticSovereignEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.getLibrary().hasCards()) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.getManaValue() % 2 == 1) {
            if (player.chooseUse(this.outcome, "Cast " + card.getLogName() + " without paying its mana cost?", source, game)) {
                game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
                player.cast(player.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
            } else {
                player.drawCards(1, source, game);
            }
        } else {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

