/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class YggdrasilRebirthEngineExileAllCreaturesGraveyardEffect
extends OneShotEffect {
    YggdrasilRebirthEngineExileAllCreaturesGraveyardEffect() {
        super(Outcome.Exile);
        this.staticText = "exile all creature cards from your graveyard";
    }

    private YggdrasilRebirthEngineExileAllCreaturesGraveyardEffect(YggdrasilRebirthEngineExileAllCreaturesGraveyardEffect effect) {
        super((OneShotEffect)effect);
    }

    public YggdrasilRebirthEngineExileAllCreaturesGraveyardEffect copy() {
        return new YggdrasilRebirthEngineExileAllCreaturesGraveyardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (Ability)source);
        String exileZoneName = CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null);
        CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        if (cards.isEmpty()) {
            return true;
        }
        controller.moveCardsToExile(cards.getCards(game), source, game, false, exileZoneId, exileZoneName);
        return true;
    }
}

