/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CascadeAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class YidrisMaelstromWielderGainCascadeEffect
extends ContinuousEffectImpl {
    private final Ability cascadeAbility = new CascadeAbility();

    public YidrisMaelstromWielderGainCascadeEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "as you cast spells from your hand this turn, they gain cascade";
    }

    private YidrisMaelstromWielderGainCascadeEffect(YidrisMaelstromWielderGainCascadeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public YidrisMaelstromWielderGainCascadeEffect copy() {
        return new YidrisMaelstromWielderGainCascadeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (StackObject stackObject : game.getStack()) {
                Spell spell;
                if (!(stackObject instanceof Spell) || stackObject.isCopy() || !stackObject.isControlledBy(source.getControllerId()) || (spell = (Spell)stackObject).getFromZone() != Zone.HAND) continue;
                game.getState().addOtherAbility(spell.getCard(), this.cascadeAbility);
            }
            return true;
        }
        return false;
    }
}

