/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class YixlidJailerEffect
extends ContinuousEffectImpl {
    YixlidJailerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.LoseAbility);
        this.staticText = "Cards in graveyards lose all abilities.";
        this.dependencyTypes.add(DependencyType.AddingAbility);
    }

    private YixlidJailerEffect(YixlidJailerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public YixlidJailerEffect copy() {
        return new YixlidJailerEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller;
        if (layer == Layer.AbilityAddingRemovingEffects_6 && (controller = game.getPlayer(source.getControllerId())) != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                for (Card card : player.getGraveyard().getCards(game)) {
                    if (card == null) continue;
                    card.looseAllAbilities(game);
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

