/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class YouCannotPassWatcher
extends Watcher {
    private final Set<MageObjectReference> set = new HashSet<MageObjectReference>();

    YouCannotPassWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.BLOCKER_DECLARED) {
            return;
        }
        Permanent attacker = game.getPermanent(event.getTargetId());
        Permanent blocker = game.getPermanent(event.getSourceId());
        if (attacker == null || blocker == null) {
            return;
        }
        if (attacker.isLegendary(game)) {
            this.set.add(new MageObjectReference((MageObject)blocker, game));
        }
        if (blocker.isLegendary(game)) {
            this.set.add(new MageObjectReference((MageObject)attacker, game));
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    boolean checkCreature(Permanent permanent, Game game) {
        return this.set.contains(new MageObjectReference((MageObject)permanent, game));
    }
}

