/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class YouFindSomePrisonersEffect
extends OneShotEffect {
    YouFindSomePrisonersEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top three cards of target opponent's library. Choose one of them. Until the end of your next turn, you may play that card, and you may spend mana as though it were mana of any color to cast it";
    }

    private YouFindSomePrisonersEffect(YouFindSomePrisonersEffect effect) {
        super((OneShotEffect)effect);
    }

    public YouFindSomePrisonersEffect copy() {
        return new YouFindSomePrisonersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (player == null || opponent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, 3));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD);
        target.withNotTarget(true);
        player.choose(Outcome.PlayForFree, (Cards)cards, (TargetCard)target, source, game);
        Card card = cards.get(target.getFirstTarget(), game);
        if (card != null) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)true);
        }
        return true;
    }
}

