/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class YouLookUponTheTarrasqueEffect
extends RequirementEffect {
    YouLookUponTheTarrasqueEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "All creatures your opponents control able to block that creature this turn do so";
    }

    private YouLookUponTheTarrasqueEffect(YouLookUponTheTarrasqueEffect effect) {
        super((RequirementEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent attackingCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return attackingCreature != null && attackingCreature.isAttacking() && game.getOpponents(source.getControllerId()).contains(permanent.getControllerId()) && permanent.canBlock(this.getTargetPointer().getFirst(game, source), game);
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return true;
    }

    public UUID mustBlockAttacker(Ability source, Game game) {
        return this.getTargetPointer().getFirst(game, source);
    }

    public YouLookUponTheTarrasqueEffect copy() {
        return new YouLookUponTheTarrasqueEffect(this);
    }
}

