/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class ZackFairEffect
extends OneShotEffect {
    ZackFairEffect() {
        super(Outcome.Benefit);
        this.staticText = "and attach an Equipment that was attached to {this} to that creature";
    }

    private ZackFairEffect(ZackFairEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZackFairEffect copy() {
        return new ZackFairEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipment;
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || creature == null) {
            return false;
        }
        List permanents = permanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(p -> p.hasSubtype(SubType.EQUIPMENT, game)).collect(Collectors.toList());
        switch (permanents.size()) {
            case 0: {
                return false;
            }
            case 1: {
                equipment = (Permanent)RandomUtil.randomFromCollection(permanents);
                break;
            }
            default: {
                FilterPermanent filter = new FilterPermanent(SubType.EQUIPMENT, "Equipment to attach to " + creature.getIdName());
                filter.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
                TargetPermanent target = new TargetPermanent(filter);
                target.withNotTarget(true);
                Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.choose(this.outcome, (Target)target, source, game));
                equipment = game.getPermanent(target.getFirstTarget());
            }
        }
        return Optional.ofNullable(equipment).map(MageItem::getId).map(uuid -> creature.addAttachment(uuid, source, game)).orElse(false);
    }
}

