/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ZamWesselEffect
extends OneShotEffect {
    ZamWesselEffect() {
        super(Outcome.Benefit);
        this.staticText = "";
    }

    private ZamWesselEffect(ZamWesselEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZamWesselEffect copy() {
        return new ZamWesselEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer;
        TargetOpponent targetOpponent;
        Player you = game.getPlayer(source.getControllerId());
        if (you.chooseTarget(Outcome.Benefit, (Target)(targetOpponent = new TargetOpponent()), source, game) && (targetPlayer = game.getPlayer(targetOpponent.getFirstTarget())) != null && you != null && !targetPlayer.getHand().isEmpty()) {
            Card card;
            TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
            if (you.choose(Outcome.Benefit, targetPlayer.getHand(), target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                CopyEffect copyEffect = new CopyEffect(Duration.EndOfGame, (MageObject)card.getMainCard(), source.getSourceId());
                copyEffect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
                game.addEffect((ContinuousEffect)copyEffect, source);
                return true;
            }
        }
        return false;
    }
}

