/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.common.CopySpellForEachItCouldTargetEffect;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ZevlorElturelExileEffect
extends CopySpellForEachItCouldTargetEffect {
    ZevlorElturelExileEffect() {
    }

    protected StackObject getStackObject(Game game, Ability source) {
        return (Spell)this.getValue("savedSpell");
    }

    protected Player getPlayer(Game game, Ability source) {
        return game.getPlayer(source.getControllerId());
    }

    protected List<MageObjectReferencePredicate> prepareCopiesWithTargets(StackObject stackObject, Player player, Ability source, Game game) {
        UUID targetId = (UUID)this.getValue("targetId");
        ArrayList<MageObjectReferencePredicate> predicates = new ArrayList<MageObjectReferencePredicate>();
        for (UUID opponentId : game.getOpponents(player.getId())) {
            Player opponent;
            if (opponentId.equals(targetId) || (opponent = game.getPlayer(opponentId)) == null) continue;
            boolean canTargetPlayer = stackObject.canTarget(game, opponentId);
            Set targetAb = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, opponentId, source, game).stream().map(MageItem::getId).filter(uuid -> stackObject.canTarget(game, uuid)).collect(Collectors.toSet());
            if (!canTargetPlayer && targetAb.isEmpty()) continue;
            if (canTargetPlayer && (targetAb.isEmpty() || player.chooseUse(this.outcome, "Have the copy target " + opponent.getName() + " or a permanent they control?", null, opponent.getName(), "A permanent they control", source, game))) {
                predicates.add(new MageObjectReferencePredicate(new MageObjectReference(opponentId)));
                continue;
            }
            if (targetAb.isEmpty()) continue;
            if (targetAb.size() == 1) {
                predicates.add(new MageObjectReferencePredicate((UUID)targetAb.iterator().next(), game));
                continue;
            }
            FilterPermanent filter = new FilterPermanent("Permanent to target");
            filter.add(Predicates.or((Iterable)targetAb.stream().map(PermanentIdPredicate::new).collect(Collectors.toSet())));
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            predicates.add(new MageObjectReferencePredicate(target.getFirstTarget(), game));
        }
        return predicates;
    }

    private ZevlorElturelExileEffect(ZevlorElturelExileEffect effect) {
        super((CopySpellForEachItCouldTargetEffect)effect);
    }

    public ZevlorElturelExileEffect copy() {
        return new ZevlorElturelExileEffect(this);
    }
}

