/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class ZhurTaaDruidAbility
extends TriggeredAbilityImpl {
    ZhurTaaDruidAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamagePlayersEffect(1, TargetController.OPPONENT));
        this.setTriggerPhrase("Whenever you tap {this} for mana, ");
        this.withRuleTextReplacement(true);
    }

    private ZhurTaaDruidAbility(ZhurTaaDruidAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent == this.getSourcePermanentOrLKI(game) && this.isControlledBy(event.getPlayerId());
    }

    public ZhurTaaDruidAbility copy() {
        return new ZhurTaaDruidAbility(this);
    }
}

