/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.PrimoTheIndivisibleToken;

class ZimoneAllQuestioningEffect
extends OneShotEffect {
    ZimoneAllQuestioningEffect() {
        super(Outcome.Benefit);
        this.staticText = "create Primo, the Indivisible, a legendary 0/0 green and blue Fractal creature token, then put that many +1/+1 counters on it";
    }

    private ZimoneAllQuestioningEffect(ZimoneAllQuestioningEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZimoneAllQuestioningEffect copy() {
        return new ZimoneAllQuestioningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PrimoTheIndivisibleToken token = new PrimoTheIndivisibleToken();
        token.putOntoBattlefield(1, game, source);
        int count = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), source, game);
        if (count < 1) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(count), source, game);
        }
        return true;
    }
}

