/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class ZirdaTheDawnwakerEffect
extends CostModificationEffectImpl {
    ZirdaTheDawnwakerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Abilities you activate that aren't mana abilities cost {2} less to activate. This effect can't reduce the mana in that cost to less than one mana";
    }

    private ZirdaTheDawnwakerEffect(ZirdaTheDawnwakerEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int reduceMax = CardUtil.calculateActualPossibleGenericManaReduction((Mana)abilityToModify.getManaCostsToPay().getMana(), (int)2, (int)1);
        if (reduceMax < 1) {
            return true;
        }
        CardUtil.reduceCost((Ability)abilityToModify, (int)reduceMax);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.isNonManaActivatedAbility() && abilityToModify.isControlledBy(source.getControllerId());
    }

    public ZirdaTheDawnwakerEffect copy() {
        return new ZirdaTheDawnwakerEffect(this);
    }
}

