/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ZoZuThePunisherAbility
extends TriggeredAbilityImpl {
    public ZoZuThePunisherAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2));
    }

    private ZoZuThePunisherAbility(ZoZuThePunisherAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ZoZuThePunisherAbility copy() {
        return new ZoZuThePunisherAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player;
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isLand(game) && (player = game.getPlayer(permanent.getControllerId())) != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a land enters the battlefield, {this} deals 2 damage to that land's controller.";
    }
}

