/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ZopandrelHungerDominusEffect
extends OneShotEffect {
    ZopandrelHungerDominusEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "double the power and toughness of each creature you control until end of turn";
    }

    private ZopandrelHungerDominusEffect(ZopandrelHungerDominusEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZopandrelHungerDominusEffect copy() {
        return new ZopandrelHungerDominusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), game)) {
            BoostTargetEffect effect = new BoostTargetEffect(permanent.getPower().getValue(), permanent.getToughness().getValue());
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

