/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ZurEternalSchemerEffect
extends ContinuousEffectImpl {
    ZurEternalSchemerEffect() {
        super(Duration.EndOfGame, Outcome.BecomeCreature);
        this.staticText = "Target non-Aura enchantment you control becomes a creature in addition to its other types and has base power and base toughness each equal to its mana value.";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private ZurEternalSchemerEffect(ZurEternalSchemerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ZurEternalSchemerEffect copy() {
        return new ZurEternalSchemerEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (enchantment == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                if (sublayer != SubLayer.NA || enchantment.isCreature(game)) break;
                enchantment.addCardType(game, new CardType[]{CardType.CREATURE});
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                int cmc = enchantment.getManaValue();
                enchantment.getPower().setModifiedBaseValue(cmc);
                enchantment.getToughness().setModifiedBaseValue(cmc);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
    }
}

