/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.z.ZygonInfiltratorCopyEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ZygonInfiltratorEffect
extends OneShotEffect {
    ZygonInfiltratorEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of that creature for as long as that creature remains tapped.";
    }

    private ZygonInfiltratorEffect(ZygonInfiltratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZygonInfiltratorEffect copy() {
        return new ZygonInfiltratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent tappedCreature = game.getPermanent(source.getFirstTarget());
        Permanent sourceCreature = source.getSourcePermanentIfItStillExists(game);
        if (tappedCreature == null || sourceCreature == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new ZygonInfiltratorCopyEffect(sourceCreature, tappedCreature), source);
        return true;
    }
}

