/*
 * Decompiled with CFR 0.152.
 */
package mage;

public enum ManaSymbol {
    W("{W}", Type.PRIMARY, Type.COLORED, Type.MONOCOLORED),
    U("{U}", Type.PRIMARY, Type.COLORED, Type.MONOCOLORED),
    B("{B}", Type.PRIMARY, Type.COLORED, Type.MONOCOLORED),
    R("{R}", Type.PRIMARY, Type.COLORED, Type.MONOCOLORED),
    G("{G}", Type.PRIMARY, Type.COLORED, Type.MONOCOLORED),
    C("{C}", Type.COLORLESS),
    X("{X}", Type.GENERIC, Type.COLORLESS),
    NUMERIC("{N/A}", Type.GENERIC, Type.COLORLESS),
    HYBRID_WU("{W/U}", W, U, Type.HYBRID, Type.COLORED),
    HYBRID_WB("{W/B}", W, B, Type.HYBRID, Type.COLORED),
    HYBRID_UB("{U/B}", U, B, Type.HYBRID, Type.COLORED),
    HYBRID_UR("{U/R}", U, R, Type.HYBRID, Type.COLORED),
    HYBRID_BR("{B/R}", B, R, Type.HYBRID, Type.COLORED),
    HYBRID_BG("{B/G}", B, G, Type.HYBRID, Type.COLORED),
    HYBRID_RG("{R/G}", R, G, Type.HYBRID, Type.COLORED),
    HYBRID_RW("{R/W}", R, W, Type.HYBRID, Type.COLORED),
    HYBRID_GW("{G/W}", G, W, Type.HYBRID, Type.COLORED),
    HYBRID_GU("{G/U}", G, U, Type.HYBRID, Type.COLORED),
    HYBRID_CW("{W/U}", W, U, Type.HYBRID, Type.COLORED),
    HYBRID_CU("{W/U}", W, U, Type.HYBRID, Type.COLORED),
    HYBRID_CB("{W/B}", W, B, Type.HYBRID, Type.COLORED),
    HYBRID_CR("{U/R}", U, R, Type.HYBRID, Type.COLORED),
    HYBRID_CG("{B/G}", B, G, Type.HYBRID, Type.COLORED),
    MONOCOLORED_HYBRID_W("{2/W}", W, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    MONOCOLORED_HYBRID_U("{2/U}", U, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    MONOCOLORED_HYBRID_B("{2/B}", B, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    MONOCOLORED_HYBRID_R("{2/R}", R, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    MONOCOLORED_HYBRID_G("{2/G}", G, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    COLORLESS_HYBRID_W("{C/W}", C, W, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    COLORLESS_HYBRID_U("{C/U}", C, U, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    COLORLESS_HYBRID_B("{C/B}", C, B, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    COLORLESS_HYBRID_R("{C/R}", C, R, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    COLORLESS_HYBRID_G("{C/G}", C, G, Type.HYBRID, Type.MONOCOLORED, Type.COLORED),
    PHYREXIAN_W("{W/P}", W, Type.PHYREXIAN, Type.COLORED, Type.MONOCOLORED),
    PHYREXIAN_G("{G/P}", G, Type.PHYREXIAN, Type.COLORED, Type.MONOCOLORED),
    PHYREXIAN_R("{R/P}", R, Type.PHYREXIAN, Type.COLORED, Type.MONOCOLORED),
    PHYREXIAN_B("{B/P}", B, Type.PHYREXIAN, Type.COLORED, Type.MONOCOLORED),
    PHYREXIAN_U("{U/P}", U, Type.PHYREXIAN, Type.COLORED, Type.MONOCOLORED),
    PHYREXIAN_HYBRID_WU("{W/U/P}", W, U, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_WB("{W/B/P}", W, B, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_UB("{U/B/P}", U, B, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_UR("{U/R/P}", U, R, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_BR("{B/R/P}", B, R, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_BG("{B/G/P}", B, G, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_RG("{R/G/P}", R, G, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_RW("{R/W/P}", R, W, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_GW("{G/W/P}", G, W, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    PHYREXIAN_HYBRID_GU("{G/U/P}", G, U, Type.PHYREXIAN, Type.HYBRID, Type.COLORED),
    SNOW("{S}", Type.SNOW);

    private final String symbol;
    private final boolean primary;
    private final boolean colored;
    private final boolean generic;
    private final boolean colorless;
    private final boolean monocolored;
    private final boolean hybrid;
    private final boolean phyrexian;
    private final boolean snow;
    private final boolean white;
    private final boolean blue;
    private final boolean black;
    private final boolean red;
    private final boolean green;
    private final ManaSymbol manaSymbol1;
    private final ManaSymbol manaSymbol2;

    private ManaSymbol(String symbol, ManaSymbol manaSymbol1, ManaSymbol manaSymbol2, Type ... types) {
        this.symbol = symbol;
        boolean lPrimary = false;
        boolean lColored = false;
        boolean lGeneric = false;
        boolean lColorless = false;
        boolean lMonocolored = false;
        boolean lHybrid = false;
        boolean lPhyrexian = false;
        boolean lSnow = false;
        block10: for (Type type : types) {
            switch (type) {
                case PRIMARY: {
                    lPrimary = true;
                    continue block10;
                }
                case COLORED: {
                    lColored = true;
                    continue block10;
                }
                case GENERIC: {
                    lGeneric = true;
                    continue block10;
                }
                case COLORLESS: {
                    lColorless = true;
                    continue block10;
                }
                case MONOCOLORED: {
                    lMonocolored = true;
                    continue block10;
                }
                case HYBRID: {
                    lHybrid = true;
                    continue block10;
                }
                case PHYREXIAN: {
                    lPhyrexian = true;
                    continue block10;
                }
                case SNOW: {
                    lSnow = true;
                }
            }
        }
        this.primary = lPrimary;
        this.colored = lColored;
        this.generic = lGeneric;
        this.colorless = lColorless;
        this.monocolored = lMonocolored;
        this.hybrid = lHybrid;
        this.phyrexian = lPhyrexian;
        this.snow = lSnow;
        this.white = symbol.contains("W");
        this.blue = symbol.contains("U");
        this.black = symbol.contains("B");
        this.red = symbol.contains("R");
        this.green = symbol.contains("G");
        this.manaSymbol1 = manaSymbol1;
        this.manaSymbol2 = manaSymbol2;
    }

    private ManaSymbol(String symbol, ManaSymbol manaSymbol, Type ... types) {
        this(symbol, manaSymbol, (ManaSymbol)null, types);
    }

    private ManaSymbol(String symbol, Type ... types) {
        this(symbol, (ManaSymbol)null, (ManaSymbol)null, types);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isColored() {
        return this.colored;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public boolean isColorless() {
        return this.colorless;
    }

    public boolean isMonocolored() {
        return this.monocolored;
    }

    public boolean isHybrid() {
        return this.hybrid;
    }

    public boolean isPhyrexian() {
        return this.phyrexian;
    }

    public boolean isSnow() {
        return this.snow;
    }

    public boolean isWhite() {
        return this.white;
    }

    public boolean isBlue() {
        return this.blue;
    }

    public boolean isBlack() {
        return this.black;
    }

    public boolean isRed() {
        return this.red;
    }

    public boolean isGreen() {
        return this.green;
    }

    public ManaSymbol getManaSymbol1() {
        return this.manaSymbol1;
    }

    public ManaSymbol getManaSymbol2() {
        return this.manaSymbol2;
    }

    public String toString() {
        return this.symbol;
    }

    private static enum Type {
        PRIMARY,
        COLORED,
        GENERIC,
        COLORLESS,
        MONOCOLORED,
        HYBRID,
        PHYREXIAN,
        SNOW;

    }
}

