/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.mana.ManaOptions;
import mage.constants.TargetController;
import mage.constants.TimingRule;
import mage.game.Game;

public interface ActivatedAbility
extends Ability {
    public ActivationStatus canActivate(UUID var1, Game var2);

    public ActivatedAbility setMayActivate(TargetController var1);

    public ManaOptions getMinimumCostToActivate(UUID var1, Game var2);

    @Override
    public ActivatedAbility copy();

    public void setMaxActivationsPerTurn(int var1);

    public int getMaxActivationsPerTurn(Game var1);

    public int getMaxMoreActivationsThisTurn(Game var1);

    public ActivatedAbility setTiming(TimingRule var1);

    public ActivatedAbility setCondition(Condition var1);

    public static final class ActivationStatus {
        private final Set<ApprovingObject> approvingObjects;
        private final boolean forcedCanActivate;
        private static final ActivationStatus falseInstance = new ActivationStatus(Collections.emptySet());

        public ActivationStatus(ApprovingObject approvingObject) {
            this.forcedCanActivate = false;
            this.approvingObjects = Collections.singleton(approvingObject);
        }

        public ActivationStatus(Set<ApprovingObject> approvingObjects) {
            this(false, approvingObjects);
        }

        private ActivationStatus(boolean forcedCanActivate, Set<ApprovingObject> approvingObjects) {
            this.forcedCanActivate = forcedCanActivate;
            this.approvingObjects = new HashSet<ApprovingObject>();
            this.approvingObjects.addAll(approvingObjects);
        }

        public boolean canActivate() {
            return this.forcedCanActivate || !this.approvingObjects.isEmpty();
        }

        public Set<ApprovingObject> getApprovingObjects() {
            return this.approvingObjects;
        }

        public static ActivationStatus getFalse() {
            return falseInstance;
        }

        public static ActivationStatus withoutApprovingObject(boolean forcedCanActivate) {
            return new ActivationStatus(forcedCanActivate, Collections.emptySet());
        }
    }
}

