/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.Iterator;
import mage.abilities.AbilitiesImpl;
import mage.abilities.DelayedTriggeredAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

public class DelayedTriggeredAbilities
extends AbilitiesImpl<DelayedTriggeredAbility> {
    public DelayedTriggeredAbilities() {
    }

    protected DelayedTriggeredAbilities(DelayedTriggeredAbilities abilities) {
        super(abilities);
    }

    @Override
    public DelayedTriggeredAbilities copy() {
        return new DelayedTriggeredAbilities(this);
    }

    public void checkTriggers(GameEvent event, Game game) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DelayedTriggeredAbility ability = (DelayedTriggeredAbility)it.next();
            if (ability.getDuration() == Duration.Custom && ability.isInactive(game)) {
                it.remove();
                continue;
            }
            if (!ability.checkEventType(event, game) || !ability.checkTrigger(event, game)) continue;
            ability.trigger(game, ability.controllerId, event);
            if (!ability.getTriggerOnlyOnce()) continue;
            it.remove();
        }
    }

    public void removeEndOfTurnAbilities(Game game) {
        this.removeIf((? super E ability) -> ability.getDuration() == Duration.EndOfTurn);
    }

    public void removeStartOfNewTurn(Game game) {
        this.removeIf((? super E ability) -> ability.getDuration() == Duration.UntilYourNextTurn && game.getActivePlayerId().equals(ability.getControllerId()));
    }

    public void removeEndOfCombatAbilities() {
        this.removeIf((? super E ability) -> ability.getDuration() == Duration.EndOfCombat);
    }
}

