/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.StateTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;
import mage.util.Copyable;
import org.apache.log4j.Logger;

public class TriggeredAbilities
extends LinkedHashMap<String, TriggeredAbility>
implements Copyable<TriggeredAbilities> {
    private static final Logger logger = Logger.getLogger(TriggeredAbilities.class);
    private final Map<String, List<UUID>> sources = new HashMap<String, List<UUID>>();
    private boolean enableIntegrityChecks = false;
    private boolean enableIntegrityCheck1_MustKeepSameTriggersOrder = true;
    private boolean enableIntegrityCheck2_MustKeepSameTriggersList = false;
    private boolean enableIntegrityCheck3_CantStartEventProcessingBeforeFinishPrev = false;
    private boolean enableIntegrityCheck4_EventMustProcessAllOldTriggers = true;
    private boolean enableIntegrityCheck5_EventMustProcessInSameOrder = true;
    private boolean enableIntegrityCheck6_EventMustNotProcessNewTriggers = false;
    private boolean enableIntegrityLogs = false;
    private boolean processingStarted = false;
    private GameEvent.EventType processingStartedEvent = null;
    private List<TriggeredAbility> processingNeed = new ArrayList<TriggeredAbility>();
    private List<TriggeredAbility> processingDone = new ArrayList<TriggeredAbility>();

    public TriggeredAbilities() {
    }

    protected TriggeredAbilities(TriggeredAbilities abilities) {
        this.makeSureNotProcessing(null);
        for (Map.Entry entry : abilities.entrySet()) {
            this.put(entry.getKey(), ((TriggeredAbility)entry.getValue()).copy());
        }
        for (Map.Entry<Object, Object> entry : abilities.sources.entrySet()) {
            this.sources.put((String)entry.getKey(), (List<UUID>)entry.getValue());
        }
        this.enableIntegrityChecks = abilities.enableIntegrityChecks;
        this.enableIntegrityCheck1_MustKeepSameTriggersOrder = abilities.enableIntegrityCheck1_MustKeepSameTriggersOrder;
        this.enableIntegrityCheck2_MustKeepSameTriggersList = abilities.enableIntegrityCheck2_MustKeepSameTriggersList;
        this.enableIntegrityCheck3_CantStartEventProcessingBeforeFinishPrev = abilities.enableIntegrityCheck3_CantStartEventProcessingBeforeFinishPrev;
        this.enableIntegrityCheck4_EventMustProcessAllOldTriggers = abilities.enableIntegrityCheck4_EventMustProcessAllOldTriggers;
        this.enableIntegrityCheck5_EventMustProcessInSameOrder = abilities.enableIntegrityCheck5_EventMustProcessInSameOrder;
        this.enableIntegrityCheck6_EventMustNotProcessNewTriggers = abilities.enableIntegrityCheck6_EventMustNotProcessNewTriggers;
        this.enableIntegrityLogs = abilities.enableIntegrityLogs;
        this.processingStarted = abilities.processingStarted;
        this.processingStartedEvent = abilities.processingStartedEvent;
        this.processingNeed = CardUtil.deepCopyObject(abilities.processingNeed);
        this.processingDone = CardUtil.deepCopyObject(abilities.processingDone);
        if (this.enableIntegrityChecks && this.enableIntegrityCheck1_MustKeepSameTriggersOrder && !Objects.equals(this.values().stream().findFirst().orElse(null) + "", abilities.values().stream().findFirst().orElse(null) + "")) {
            throw new IllegalStateException("Triggers integrity failed: triggers order changed");
        }
    }

    public void checkStateTriggers(Game game) {
        this.makeSureNotProcessing(null);
        this.processingStart(null);
        boolean needErrorChecksOnEnd = true;
        try {
            for (TriggeredAbility ability : this.values()) {
                if (ability instanceof StateTriggeredAbility && ((StateTriggeredAbility)ability).canTrigger(game)) {
                    this.checkTrigger(ability, null, game);
                }
                this.processingDone(ability);
            }
        }
        catch (Exception e) {
            needErrorChecksOnEnd = false;
            throw e;
        }
        finally {
            this.processingEnd(needErrorChecksOnEnd);
        }
    }

    public void checkTriggers(GameEvent event, Game game) {
        this.processingStart(event);
        boolean needErrorChecksOnEnd = true;
        ArrayList currentTriggers = new ArrayList(this.values());
        try {
            for (TriggeredAbility ability : currentTriggers) {
                if (ability.checkEventType(event, game)) {
                    this.checkTrigger(ability, event, game);
                }
                this.processingDone(ability);
            }
        }
        catch (Exception e) {
            needErrorChecksOnEnd = false;
            throw e;
        }
        finally {
            this.processingEnd(needErrorChecksOnEnd);
        }
    }

    private void makeSureNotProcessing(GameEvent newEvent) {
        if (!this.enableIntegrityChecks) {
            return;
        }
        if (this.enableIntegrityChecks && this.enableIntegrityCheck2_MustKeepSameTriggersList && this.processingStarted) {
            ArrayList<String> info = new ArrayList<String>();
            info.add("old event: " + (Object)((Object)this.processingStartedEvent));
            info.add("new event: " + (Object)((Object)newEvent.getType()));
            throw new IllegalArgumentException("Triggers integrity failed: triggers can't be modified while processing - " + String.join((CharSequence)", ", info));
        }
    }

    private void processingStart(GameEvent newEvent) {
        if (!this.enableIntegrityChecks) {
            return;
        }
        this.makeSureNotProcessing(newEvent);
        this.processingStarted = true;
        this.processingStartedEvent = newEvent == null ? null : newEvent.getType();
        this.processingNeed.clear();
        this.processingNeed.addAll(this.values());
        this.processingDone.clear();
    }

    private void processingDone(TriggeredAbility trigger) {
        if (!this.enableIntegrityChecks) {
            return;
        }
        this.processingDone.add(trigger);
    }

    private void processingEnd(boolean needErrorChecks) {
        if (!this.enableIntegrityChecks) {
            return;
        }
        if (needErrorChecks) {
            if (this.enableIntegrityChecks && this.enableIntegrityCheck3_CantStartEventProcessingBeforeFinishPrev && !this.processingStarted) {
                throw new IllegalArgumentException("Triggers integrity failed: can't finish event before start");
            }
            ArrayList needIds = new ArrayList();
            String needInfo = this.processingNeed.stream().peek(a -> needIds.add(a.getId())).map(t -> "- " + t).sorted().collect(Collectors.joining("\n"));
            ArrayList doneIds = new ArrayList();
            String doneInfo = this.processingDone.stream().peek(a -> doneIds.add(a.getId())).map(t -> "- " + t).sorted().collect(Collectors.joining("\n"));
            String errorInfo = "\nNeed: \n" + (needInfo.isEmpty() ? "-" : needInfo) + "\nDone: \n" + (doneInfo.isEmpty() ? "-" : doneInfo);
            if (this.enableIntegrityChecks && this.enableIntegrityCheck4_EventMustProcessAllOldTriggers && this.processingDone.size() < this.processingNeed.size()) {
                throw new IllegalArgumentException("Triggers integrity failed: event processing miss some triggers" + errorInfo);
            }
            if (this.enableIntegrityChecks && this.enableIntegrityCheck5_EventMustProcessInSameOrder && this.processingDone.size() > 0 && this.processingDone.size() == this.processingNeed.size() && !((Object)needIds).toString().equals(((Object)doneIds).toString())) {
                throw new IllegalArgumentException("Triggers integrity failed: event processing used wrong order" + errorInfo);
            }
            if (this.enableIntegrityChecks && this.enableIntegrityCheck6_EventMustNotProcessNewTriggers && this.processingDone.size() > this.processingNeed.size()) {
                throw new IllegalArgumentException("Triggers integrity failed: event processing must not process new triggers" + errorInfo);
            }
        }
        this.processingStarted = false;
        this.processingStartedEvent = null;
        this.processingNeed.clear();
        this.processingDone.clear();
    }

    private void checkTrigger(TriggeredAbility ability, GameEvent event, Game game) {
        MageObject object;
        if (this.enableIntegrityLogs) {
            logger.info((Object)"---");
            logger.info((Object)("checking trigger: " + ability));
            logger.info((Object)("playable state: " + game.inCheckPlayableState()));
            logger.info((Object)game);
            logger.info((Object)("battlefield:\n" + game.getBattlefield().getAllPermanents().stream().map(p -> "- " + p.toString()).collect(Collectors.joining("\n")) + "\n"));
        }
        if (ability.isInUseableZone(game, object = game.getObject(ability.getSourceId()), event) && (event == null || !game.getContinuousEffects().preventedByRuleModification(event, ability, game, false))) {
            if (object != null) {
                Permanent permanent;
                boolean controllerSet = false;
                Set<UUID> eventTargets = CardUtil.getEventTargets(event);
                if (ability.getZone() != Zone.COMMAND && event != null && !eventTargets.isEmpty() && ability.isLeavesTheBattlefieldTrigger() && game.getLKI().get((Object)Zone.BATTLEFIELD) != null && game.getLKI().get((Object)Zone.BATTLEFIELD).containsKey(ability.getSourceId()) && (permanent = (Permanent)game.getLastKnownInformation(ability.getSourceId(), Zone.BATTLEFIELD, ability.getStackMomentSourceZCC() - 1)) != null) {
                    if (permanent.isFaceDown(game) && !this.isGainedAbility(ability, permanent) && !ability.getWorksFaceDown()) {
                        return;
                    }
                    controllerSet = true;
                    ability.setControllerId(permanent.getControllerId());
                }
                if (!controllerSet) {
                    if (object instanceof Permanent) {
                        ability.setControllerId(((Permanent)object).getControllerId());
                    } else if (object instanceof Spell) {
                        ability.setControllerId(((Spell)object).getControllerId());
                    }
                }
            }
            if (ability.checkTrigger(event, game) && ability.checkTriggeredLimit(game) && !ability.checkUsedAlready(game)) {
                NumberOfTriggersEvent numberOfTriggersEvent = new NumberOfTriggersEvent(ability, event);
                if (event == null || !game.replaceEvent(numberOfTriggersEvent, ability)) {
                    int limit = Integer.min(ability.getRemainingTriggersLimitEachGame(game), ability.getRemainingTriggersLimitEachTurn(game));
                    int numTriggers = Integer.min(limit, numberOfTriggersEvent.getAmount());
                    for (int i = 0; i < numTriggers; ++i) {
                        if (this.enableIntegrityLogs) {
                            logger.info((Object)("trigger will be USED: " + ability));
                        }
                        ability.trigger(game, ability.getControllerId(), event);
                    }
                }
            }
        }
    }

    public void add(TriggeredAbility ability, UUID sourceId, MageObject attachedTo) {
        this.makeSureNotProcessing(null);
        if (sourceId == null) {
            this.add(ability, attachedTo);
        } else if (attachedTo == null) {
            this.put(ability.getId() + "_" + sourceId, ability);
        } else {
            this.add(ability, attachedTo);
            LinkedList<UUID> uuidList = new LinkedList<UUID>();
            uuidList.add(sourceId);
            uuidList.add(attachedTo.getId());
            this.sources.put(this.getKey(ability, attachedTo), uuidList);
        }
    }

    public void add(TriggeredAbility ability, MageObject attachedTo) {
        this.makeSureNotProcessing(null);
        this.put(this.getKey(ability, attachedTo), ability);
    }

    private String getKey(TriggeredAbility ability, MageObject target) {
        String key = ability.getId() + "_";
        if (target != null) {
            key = key + target.getId();
        }
        return key;
    }

    public void removeAbilitiesOfSource(UUID sourceId) {
        this.keySet().removeIf(key -> key.endsWith(sourceId.toString()));
    }

    public void removeAllGainedAbilities() {
        this.keySet().removeAll(this.sources.keySet());
        this.sources.clear();
    }

    public boolean isGainedAbility(TriggeredAbility abilityToCheck, MageObject attachedTo) {
        return this.sources.containsKey(this.getKey(abilityToCheck, attachedTo));
    }

    public void removeAbilitiesOfNonExistingSources(Game game) {
        this.entrySet().removeIf(entry -> game.getObject(((TriggeredAbility)entry.getValue()).getSourceId()) == null && game.getState().getHelperEmblems().stream().noneMatch(emblem -> emblem.getId().equals(((TriggeredAbility)entry.getValue()).getSourceId())) && game.getState().getDesignations().stream().noneMatch(designation -> designation.getId().equals(((TriggeredAbility)entry.getValue()).getSourceId())));
    }

    @Override
    public TriggeredAbilities copy() {
        return new TriggeredAbilities(this);
    }
}

