/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.ArrayList;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.AnimateDeadPredicate;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EnchantAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class AnimateDeadReplaceAbilityEffect
extends ContinuousEffectImpl {
    private final boolean becomesAura;
    private Ability newAbility;
    private TargetPermanent newTarget;

    public AnimateDeadReplaceAbilityEffect(boolean becomesAura) {
        super(Duration.Custom, Outcome.AddAbility);
        this.becomesAura = becomesAura;
        this.staticText = (becomesAura ? "it becomes an Aura with" : "it loses \"enchant creature card in a graveyard\" and gains") + " \"enchant creature put onto the battlefield with {this}.\"";
        if (becomesAura) {
            this.dependencyTypes.add(DependencyType.AuraAddingRemoving);
        }
    }

    private AnimateDeadReplaceAbilityEffect(AnimateDeadReplaceAbilityEffect effect) {
        super(effect);
        this.becomesAura = effect.becomesAura;
        this.newAbility = effect.newAbility;
        this.newTarget = effect.newTarget;
    }

    @Override
    public AnimateDeadReplaceAbilityEffect copy() {
        return new AnimateDeadReplaceAbilityEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game));
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature put onto the battlefield with {this}");
        filter.add(new AnimateDeadPredicate(source.getSourceId()));
        this.newTarget = new TargetPermanent(filter);
        this.newAbility = new EnchantAbility(this.newTarget);
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game);
        if (permanent == null) {
            this.discard();
            return true;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                if (!this.becomesAura) break;
                permanent.addSubType(game, SubType.AURA);
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                if (!this.becomesAura) {
                    ArrayList<Ability> toRemove = new ArrayList<Ability>();
                    for (Ability ability : permanent.getAbilities(game)) {
                        if (!(ability instanceof EnchantAbility) || !ability.getRule().equals("Enchant creature card in a graveyard")) continue;
                        toRemove.add(ability);
                    }
                    permanent.removeAbilities(toRemove, source.getSourceId(), game);
                }
                permanent.addAbility(this.newAbility, source.getSourceId(), game);
                permanent.getSpellAbility().getTargets().clear();
                permanent.getSpellAbility().getTargets().add(this.newTarget);
            }
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return Layer.AbilityAddingRemovingEffects_6 == layer || this.becomesAura && Layer.TypeChangingEffects_4 == layer;
    }
}

