/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class AnimateDeadWatcher
extends Watcher {
    private final Set<UUID> putBySource = new HashSet<UUID>();

    public AnimateDeadWatcher() {
        super(WatcherScope.CARD);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ZONE_CHANGE: {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                if (this.sourceId.equals(zEvent.getTargetId())) {
                    this.putBySource.clear();
                    return;
                }
                if (zEvent.getToZone() != Zone.BATTLEFIELD) {
                    return;
                }
                if (this.sourceId.equals(zEvent.getSourceId())) {
                    this.putBySource.add(event.getTargetId());
                } else {
                    this.putBySource.remove(event.getTargetId());
                }
                return;
            }
            case BEGINNING_PHASE_PRE: {
                if (game.getTurnNum() != 1) break;
                this.putBySource.clear();
            }
        }
    }

    public boolean check(Permanent permanent) {
        return this.putBySource.contains(permanent.getId());
    }
}

