/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.AttachmentType;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class AttacksAttachedTriggeredAbility
extends TriggeredAbilityImpl {
    private final AttachmentType attachmentType;
    private final SetTargetPointer setTargetPointer;

    public AttacksAttachedTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public AttacksAttachedTriggeredAbility(Effect effect, boolean optional) {
        this(effect, AttachmentType.EQUIPMENT, optional);
    }

    public AttacksAttachedTriggeredAbility(Effect effect, AttachmentType attachmentType, boolean optional) {
        this(effect, attachmentType, optional, SetTargetPointer.NONE);
    }

    public AttacksAttachedTriggeredAbility(Effect effect, AttachmentType attachmentType, boolean optional, SetTargetPointer setTargetPointer) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.attachmentType = attachmentType;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever " + attachmentType.verb().toLowerCase() + " creature attacks, ");
    }

    protected AttacksAttachedTriggeredAbility(AttacksAttachedTriggeredAbility ability) {
        super(ability);
        this.attachmentType = ability.attachmentType;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public AttacksAttachedTriggeredAbility copy() {
        return new AttacksAttachedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attachment = this.getSourcePermanentOrLKI(game);
        UUID attackerId = event.getSourceId();
        if (attachment == null || !attackerId.equals(attachment.getAttachedTo())) {
            return false;
        }
        switch (this.setTargetPointer) {
            case PERMANENT: {
                this.getEffects().setTargetPointer(new FixedTarget(attackerId, game));
                break;
            }
            case PLAYER: {
                this.getEffects().setTargetPointer(new FixedTarget(game.getCombat().getDefendingPlayerId(attackerId, game)));
            }
        }
        return true;
    }
}

