/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.AttachmentType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class AttacksOrBlocksAttachedTriggeredAbility
extends TriggeredAbilityImpl {
    private final AttachmentType attachmentType;

    public AttacksOrBlocksAttachedTriggeredAbility(Effect effect, AttachmentType attachmentType) {
        super(Zone.BATTLEFIELD, effect);
        this.attachmentType = attachmentType;
        this.setTriggerPhrase("Whenever " + attachmentType.verb().toLowerCase() + " creature attacks or blocks, ");
    }

    protected AttacksOrBlocksAttachedTriggeredAbility(AttacksOrBlocksAttachedTriggeredAbility ability) {
        super(ability);
        this.attachmentType = ability.attachmentType;
    }

    @Override
    public AttacksOrBlocksAttachedTriggeredAbility copy() {
        return new AttacksOrBlocksAttachedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED || event.getType() == GameEvent.EventType.CREATURE_BLOCKS;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = this.getSourcePermanentOrLKI(game);
        if (enchantment == null) {
            return false;
        }
        UUID idToCheck = event.getType() == GameEvent.EventType.ATTACKER_DECLARED ? event.getSourceId() : event.getTargetId();
        return idToCheck.equals(enchantment.getAttachedTo());
    }
}

