/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class BecomesBlockedAttachedTriggeredAbility
extends TriggeredAbilityImpl {
    private final SetTargetPointer setTargetPointer;

    public BecomesBlockedAttachedTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, SetTargetPointer.NONE);
    }

    public BecomesBlockedAttachedTriggeredAbility(Effect effect, boolean optional, SetTargetPointer setTargetPointer) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever enchanted creature becomes blocked, ");
    }

    protected BecomesBlockedAttachedTriggeredAbility(BecomesBlockedAttachedTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATURE_BLOCKED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = this.getSourcePermanentOrLKI(game);
        UUID blockedId = event.getTargetId();
        if (enchantment == null || !blockedId.equals(enchantment.getAttachedTo())) {
            return false;
        }
        switch (this.setTargetPointer) {
            case PERMANENT: {
                this.getEffects().setTargetPointer(new FixedTarget(blockedId, game));
                break;
            }
            case PLAYER: {
                UUID playerId = game.getCombat().getDefendingPlayerId(blockedId, game);
                if (playerId == null) break;
                this.getEffects().setTargetPointer(new FixedTarget(playerId));
            }
        }
        return true;
    }

    @Override
    public BecomesBlockedAttachedTriggeredAbility copy() {
        return new BecomesBlockedAttachedTriggeredAbility(this);
    }
}

