/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CantHaveMoreThanAmountCountersSourceEffect
extends ReplacementEffectImpl {
    private final CounterType counterType;
    private final int amount;

    CantHaveMoreThanAmountCountersSourceEffect(CounterType counterType, int amount) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, false);
        this.counterType = counterType;
        this.amount = amount;
    }

    CantHaveMoreThanAmountCountersSourceEffect(CantHaveMoreThanAmountCountersSourceEffect effect) {
        super(effect);
        this.counterType = effect.counterType;
        this.amount = effect.amount;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTER;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
        }
        return permanent != null && permanent.getId().equals(source.getSourceId()) && event.getData().equals(this.counterType.getName()) && permanent.getCounters(game).getCount(this.counterType) == this.amount;
    }

    @Override
    public CantHaveMoreThanAmountCountersSourceEffect copy() {
        return new CantHaveMoreThanAmountCountersSourceEffect(this);
    }
}

