/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class CantPayLifeEffect
extends ContinuousEffectImpl {
    private final boolean onlyNonManaAbilities;

    CantPayLifeEffect(boolean onlyNonManaAbilities) {
        super(Duration.WhileOnBattlefield, Layer.PlayerEffects, SubLayer.NA, Outcome.Detriment);
        this.onlyNonManaAbilities = onlyNonManaAbilities;
    }

    private CantPayLifeEffect(CantPayLifeEffect effect) {
        super(effect);
        this.onlyNonManaAbilities = effect.onlyNonManaAbilities;
    }

    @Override
    public CantPayLifeEffect copy() {
        return new CantPayLifeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) {
                return false;
            }
            player.addPayLifeCostRestriction(Player.PayLifeCostRestriction.CAST_SPELLS);
            if (this.onlyNonManaAbilities) {
                player.addPayLifeCostRestriction(Player.PayLifeCostRestriction.ACTIVATE_NON_MANA_ABILITIES);
                continue;
            }
            player.addPayLifeCostRestriction(Player.PayLifeCostRestriction.ACTIVATE_MANA_ABILITIES);
            player.addPayLifeCostRestriction(Player.PayLifeCostRestriction.ACTIVATE_NON_MANA_ABILITIES);
        }
        return true;
    }
}

