/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.AbilityType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CantSacrificeEffect
extends ContinuousRuleModifyingEffectImpl {
    private final FilterPermanent sacrificeFilter;
    private final boolean onlyNonManaAbilities;

    CantSacrificeEffect(boolean onlyNonManaAbilities, FilterPermanent sacrificeFilter) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.sacrificeFilter = sacrificeFilter;
        this.onlyNonManaAbilities = onlyNonManaAbilities;
    }

    private CantSacrificeEffect(CantSacrificeEffect effect) {
        super(effect);
        this.sacrificeFilter = effect.sacrificeFilter.copy();
        this.onlyNonManaAbilities = effect.onlyNonManaAbilities;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PAY_SACRIFICE_COST;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        boolean isActivatedAbility;
        Permanent permanent = game.getPermanent(event.getTargetId());
        Optional<Ability> abilityOptional = game.getAbility(UUID.fromString(event.getData()), event.getSourceId());
        if (permanent == null || !abilityOptional.isPresent()) {
            return false;
        }
        Ability abilityWithCost = abilityOptional.get();
        boolean bl = isActivatedAbility = this.onlyNonManaAbilities && abilityWithCost.isManaActivatedAbility() || !this.onlyNonManaAbilities && abilityWithCost.isActivatedAbility();
        if (!isActivatedAbility && abilityWithCost.getAbilityType() != AbilityType.SPELL) {
            return false;
        }
        return this.sacrificeFilter.match(permanent, event.getPlayerId(), source, game);
    }

    @Override
    public CantSacrificeEffect copy() {
        return new CantSacrificeEffect(this);
    }
}

