/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.HashSet;
import java.util.Set;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.effects.common.replacement.SpellMorEnteringTappedEffect;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class CastFromGraveyardOnceWatcher
extends Watcher {
    private final Set<MageObjectReference> usedFrom = new HashSet<MageObjectReference>();

    CastFromGraveyardOnceWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (!GameEvent.EventType.SPELL_CAST.equals((Object)event.getType())) {
            return;
        }
        if (event.hasApprovingIdentifier(MageIdentifier.OnceOnYourTurnCastFromGraveyard)) {
            this.usedFrom.add(event.getApprovingObject().getApprovingMageObjectReference());
            return;
        }
        if (event.hasApprovingIdentifier(MageIdentifier.OnceOnYourTurnCastFromGraveyardEntersTapped)) {
            this.usedFrom.add(event.getApprovingObject().getApprovingMageObjectReference());
            Spell target = game.getSpell(event.getTargetId());
            if (target != null) {
                MageObjectReference mor = new MageObjectReference(target, game);
                game.getState().addEffect(new SpellMorEnteringTappedEffect(mor), event.getApprovingObject().getApprovingAbility());
            }
            return;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.usedFrom.clear();
    }

    boolean abilityUsed(MageObjectReference mor) {
        return this.usedFrom.contains(mor);
    }
}

