/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Arrays;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.GainReadAheadAbility;
import mage.abilities.keyword.ReadAheadAbility;
import mage.constants.SagaChapter;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ChapterTriggeredAbility
extends TriggeredAbilityImpl {
    private final SagaChapter chapterFrom;
    private final SagaChapter chapterTo;

    ChapterTriggeredAbility(SagaChapter chapterFrom, SagaChapter chapterTo, boolean optional) {
        super(Zone.ALL, null, optional);
        this.chapterFrom = chapterFrom;
        this.chapterTo = chapterTo;
    }

    private ChapterTriggeredAbility(ChapterTriggeredAbility ability) {
        super(ability);
        this.chapterFrom = ability.chapterFrom;
        this.chapterTo = ability.chapterTo;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getTargetId().equals(this.getSourceId()) || !event.getData().equals(CounterType.LORE.getName())) {
            return false;
        }
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        int loreCounters = permanent.getCounters(game).getCount(CounterType.LORE);
        if (permanent.getTurnsOnBattlefield() == 0 && (permanent.hasAbility(ReadAheadAbility.getInstance(), game) || GainReadAheadAbility.checkForAbility(game, this))) {
            return this.chapterFrom.getNumber() == loreCounters;
        }
        return loreCounters - event.getAmount() < this.chapterFrom.getNumber() && this.chapterFrom.getNumber() <= loreCounters;
    }

    @Override
    public ChapterTriggeredAbility copy() {
        return new ChapterTriggeredAbility(this);
    }

    public String getChapterRule() {
        String rule = super.getRule();
        return Character.toUpperCase(rule.charAt(0)) + rule.substring(1);
    }

    public SagaChapter getChapterFrom() {
        return this.chapterFrom;
    }

    public SagaChapter getChapterTo() {
        return this.chapterTo;
    }

    @Override
    public String getRule() {
        return Arrays.stream(SagaChapter.values()).filter(chapter -> this.chapterFrom.getNumber() <= chapter.getNumber()).filter(chapter -> chapter.getNumber() <= this.chapterTo.getNumber()).map(SagaChapter::toString).reduce((a, b) -> a + ", " + b).orElse("") + " - " + CardUtil.getTextWithFirstCharUpperCase(super.getRule());
    }
}

