/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;

public class CombatDamageDealtToYouTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    private final boolean setTargetPointer;

    public CombatDamageDealtToYouTriggeredAbility(Effect effect) {
        this(Zone.BATTLEFIELD, effect, false, false);
    }

    public CombatDamageDealtToYouTriggeredAbility(Zone zone, Effect effect, boolean setTargetPointer, boolean optional) {
        super(zone, effect, optional);
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    private CombatDamageDealtToYouTriggeredAbility(CombatDamageDealtToYouTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getTargetId()) || !((DamagedBatchForOnePlayerEvent)event).isCombatDamage()) {
            return false;
        }
        if (this.setTargetPointer) {
            this.getEffects().setTargetPointer(new FixedTarget(game.getActivePlayerId()));
        }
        return true;
    }

    private String generateTriggerPhrase() {
        if (this.setTargetPointer) {
            return "Whenever one or more creatures an opponent controls deal combat damage to you, ";
        }
        return "Whenever one or more creatures deal combat damage to you, ";
    }

    @Override
    public CombatDamageDealtToYouTriggeredAbility copy() {
        return new CombatDamageDealtToYouTriggeredAbility(this);
    }
}

