/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedBatchForOnePermanentEvent;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;

public class DealtCombatDamageToSourceTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    public DealtCombatDamageToSourceTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever {this} is dealt combat damage, ");
        this.withRuleTextReplacement(true);
    }

    protected DealtCombatDamageToSourceTriggeredAbility(DealtCombatDamageToSourceTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public DealtCombatDamageToSourceTriggeredAbility copy() {
        return new DealtCombatDamageToSourceTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.getSourceId().equals(event.getTargetId()) || !((DamagedBatchForOnePermanentEvent)event).isCombatDamage()) {
            return false;
        }
        this.getEffects().setValue("damage", event.getAmount());
        return true;
    }
}

