/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.StaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.EntersBattlefieldEffect;
import mage.constants.Zone;

public class EntersBattlefieldAbility
extends StaticAbility {
    protected String abilityRule;
    protected boolean optional;

    public EntersBattlefieldAbility(Effect effect) {
        this(effect, false);
    }

    public EntersBattlefieldAbility(Effect effect, boolean optional) {
        this(effect, optional, null, null, null);
    }

    public EntersBattlefieldAbility(Effect effect, String effectText) {
        this(effect, null, null, effectText);
    }

    public EntersBattlefieldAbility(Effect effect, Condition condition, String abilityRule, String effectText) {
        this(effect, false, condition, abilityRule, effectText);
    }

    public EntersBattlefieldAbility(Effect effect, boolean optional, Condition condition, String abilityRule, String effectText) {
        super(Zone.ALL, new EntersBattlefieldEffect(effect, condition, effectText, true, optional));
        this.abilityRule = abilityRule;
        this.optional = optional;
    }

    protected EntersBattlefieldAbility(EntersBattlefieldAbility ability) {
        super(ability);
        this.abilityRule = ability.abilityRule;
        this.optional = ability.optional;
    }

    @Override
    public void addEffect(Effect effect) {
        Effect entersBattlefieldEffect;
        if (!this.getEffects().isEmpty() && (entersBattlefieldEffect = (Effect)this.getEffects().get(0)) instanceof EntersBattlefieldEffect) {
            ((EntersBattlefieldEffect)entersBattlefieldEffect).addEffect(effect);
            return;
        }
        super.addEffect(effect);
    }

    @Override
    public EntersBattlefieldAbility copy() {
        return new EntersBattlefieldAbility(this);
    }

    @Override
    public String getRule() {
        if (this.abilityRule != null && !this.abilityRule.isEmpty()) {
            return this.addRulePrefix(this.abilityRule);
        }
        String superRule = super.getRule();
        String rule = (this.optional ? "you may have " : "") + "{this} enter" + (this.optional ? "" : "s") + (!superRule.isEmpty() && superRule.charAt(0) == ' ' ? "" : " ") + superRule;
        return this.addRulePrefix(rule);
    }
}

