/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class EntersBattlefieldAllTriggeredAbility
extends TriggeredAbilityImpl {
    protected FilterPermanent filter;
    protected SetTargetPointer setTargetPointer;

    public EntersBattlefieldAllTriggeredAbility(Effect effect, FilterPermanent filter) {
        this(effect, filter, false);
    }

    public EntersBattlefieldAllTriggeredAbility(Effect effect, FilterPermanent filter, boolean optional) {
        this(Zone.BATTLEFIELD, effect, filter, optional);
    }

    public EntersBattlefieldAllTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, boolean optional) {
        this(zone, effect, filter, optional, SetTargetPointer.NONE);
    }

    public EntersBattlefieldAllTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, boolean optional, SetTargetPointer setTargetPointer) {
        super(zone, effect, optional);
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.makeTriggerPhrase();
    }

    protected EntersBattlefieldAllTriggeredAbility(EntersBattlefieldAllTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (!this.filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        this.getAllEffects().setValue("permanentEnteringBattlefield", permanent);
        this.getAllEffects().setValue("permanentEnteringControllerId", permanent.getControllerId());
        switch (this.setTargetPointer) {
            case PLAYER: {
                this.getAllEffects().setTargetPointer(new FixedTarget(permanent.getControllerId()));
                break;
            }
            case PERMANENT: {
                this.getAllEffects().setTargetPointer(new FixedTarget(permanent, game));
                break;
            }
        }
        return true;
    }

    private void makeTriggerPhrase() {
        String filterMessage = this.filter.getMessage();
        if (filterMessage.startsWith("one or more")) {
            this.setTriggerPhrase(this.getWhen() + filterMessage + " enter, ");
        } else {
            this.setTriggerPhrase(this.getWhen() + CardUtil.addArticle(filterMessage) + " enters, ");
        }
    }

    @Override
    public EntersBattlefieldAllTriggeredAbility copy() {
        return new EntersBattlefieldAllTriggeredAbility(this);
    }
}

