/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.common.EntersBattlefieldControlledTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.common.PermanentWasCastWatcher;

public class EntersBattlefieldCastTriggeredAbility
extends EntersBattlefieldControlledTriggeredAbility {
    private final boolean mustCast;

    public EntersBattlefieldCastTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, boolean optional, SetTargetPointer setTargetPointer, boolean mustCast) {
        super(zone, effect, filter, optional, setTargetPointer);
        this.mustCast = mustCast;
        this.addWatcher(new PermanentWasCastWatcher());
        this.setTriggerPhrase(this.getWhen() + CardUtil.addArticle(filter.getMessage()) + " you control enters, if it " + (mustCast ? "was" : "wasn't") + " cast, ");
    }

    protected EntersBattlefieldCastTriggeredAbility(EntersBattlefieldCastTriggeredAbility ability) {
        super(ability);
        this.mustCast = ability.mustCast;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        PermanentWasCastWatcher watcher = game.getState().getWatcher(PermanentWasCastWatcher.class);
        return watcher != null && watcher.wasPermanentCastThisTurn(event.getTargetId()) == this.mustCast && super.checkTrigger(event, game);
    }

    @Override
    public EntersBattlefieldCastTriggeredAbility copy() {
        return new EntersBattlefieldCastTriggeredAbility(this);
    }
}

