/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public class EntersBattlefieldOrTurnedFaceUpTriggeredAbility
extends TriggeredAbilityImpl {
    public EntersBattlefieldOrTurnedFaceUpTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public EntersBattlefieldOrTurnedFaceUpTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setWorksFaceDown(true);
        this.setTriggerPhrase("When {this} enters or is turned face up, ");
    }

    private EntersBattlefieldOrTurnedFaceUpTriggeredAbility(EntersBattlefieldOrTurnedFaceUpTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public EntersBattlefieldOrTurnedFaceUpTriggeredAbility copy() {
        return new EntersBattlefieldOrTurnedFaceUpTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TURNED_FACE_UP || event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        switch (event.getType()) {
            case TURNED_FACE_UP: {
                return true;
            }
            case ENTERS_THE_BATTLEFIELD: {
                return Optional.ofNullable(this.getSourcePermanentIfItStillExists(game)).filter(Objects::nonNull).map(permanent -> !permanent.isFaceDown(game)).orElse(false);
            }
        }
        return false;
    }
}

