/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.common.ExpendTriggeredAbility;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class ExpendWatcher
extends Watcher {
    private final Map<UUID, Integer> manaExpended = new HashMap<UUID, Integer>();
    private final Map<UUID, UUID> eventFor4thExpend = new HashMap<UUID, UUID>();
    private final Map<UUID, UUID> eventFor6thExpend = new HashMap<UUID, UUID>();
    private final Map<UUID, UUID> eventFor8thExpend = new HashMap<UUID, UUID>();

    public ExpendWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (!GameEvent.EventType.MANA_PAID.equals((Object)event.getType())) {
            return;
        }
        MageObject ability = game.getObject(event.getTargetId());
        if (!(ability instanceof Spell)) {
            return;
        }
        UUID playerId = event.getPlayerId();
        UUID eventId = event.getId();
        this.manaExpended.compute(playerId, CardUtil::setOrIncrementValue);
        int currentValue = this.manaExpended.get(playerId);
        switch (currentValue) {
            case 4: {
                this.eventFor4thExpend.put(playerId, eventId);
                break;
            }
            case 6: {
                this.eventFor6thExpend.put(playerId, eventId);
                break;
            }
            case 8: {
                this.eventFor8thExpend.put(playerId, eventId);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.manaExpended.clear();
        this.eventFor4thExpend.clear();
        this.eventFor6thExpend.clear();
        this.eventFor8thExpend.clear();
    }

    public static boolean checkExpend(UUID playerId, GameEvent event, ExpendTriggeredAbility.Expend expendToCheck, Game game) {
        ExpendWatcher watcher = game.getState().getWatcher(ExpendWatcher.class);
        if (watcher == null) {
            return false;
        }
        switch (expendToCheck) {
            case FOUR: {
                return watcher.eventFor4thExpend.containsKey(playerId) && watcher.eventFor4thExpend.get(playerId).equals(event.getId());
            }
            case SIX: {
                return watcher.eventFor6thExpend.containsKey(playerId) && watcher.eventFor6thExpend.get(playerId).equals(event.getId());
            }
            case EIGHT: {
                return watcher.eventFor8thExpend.containsKey(playerId) && watcher.eventFor8thExpend.get(playerId).equals(event.getId());
            }
        }
        throw new IllegalArgumentException("Unsupported expend value: " + expendToCheck.getAmount());
    }

    public static int getManaExpended(UUID playerId, Game game) {
        ExpendWatcher watcher = game.getState().getWatcher(ExpendWatcher.class);
        if (watcher == null) {
            return 0;
        }
        return watcher.manaExpended.getOrDefault(playerId, 0);
    }
}

