/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;

public class ExploitCreatureTriggeredAbility
extends TriggeredAbilityImpl {
    private final SetTargetPointer setTargetPointer;

    public ExploitCreatureTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public ExploitCreatureTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, SetTargetPointer.NONE);
    }

    public ExploitCreatureTriggeredAbility(Effect effect, boolean optional, SetTargetPointer setTargetPointer) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTargetPointer = setTargetPointer;
        this.setLeavesTheBattlefieldTrigger(true);
        this.setTriggerPhrase("When {this} exploits a creature, ");
    }

    protected ExploitCreatureTriggeredAbility(ExploitCreatureTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public ExploitCreatureTriggeredAbility copy() {
        return new ExploitCreatureTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXPLOITED_CREATURE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getSourceId().equals(this.getSourceId())) {
            for (Effect effect : this.getEffects()) {
                if (this.setTargetPointer != SetTargetPointer.PERMANENT) continue;
                effect.setTargetPointer(new FixedTarget(event.getTargetId(), game));
            }
            return true;
        }
        return false;
    }
}

