/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;

class LegendarySpellAbilityCheckEffect
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent("legendary creature or planeswalker");

    public LegendarySpellAbilityCheckEffect(boolean isInstant) {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.staticText = "<i>(You may cast a legendary " + (isInstant ? "instant" : "sorcery") + " only if you control a legendary creature or planeswalker.)</i>";
    }

    private LegendarySpellAbilityCheckEffect(LegendarySpellAbilityCheckEffect effect) {
        super(effect);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getSourceId().equals(source.getSourceId()) && !game.getBattlefield().containsControlled(filter, source, game, 1);
    }

    @Override
    public LegendarySpellAbilityCheckEffect copy() {
        return new LegendarySpellAbilityCheckEffect(this);
    }

    static {
        filter.add(Predicates.and(SuperType.LEGENDARY.getPredicate(), Predicates.or(CardType.CREATURE.getPredicate(), CardType.PLANESWALKER.getPredicate())));
    }
}

