/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.SetTargetPointer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;

public class PutCardIntoGraveFromAnywhereAllTriggeredAbility
extends TriggeredAbilityImpl {
    private final FilterCard filter;
    private final SetTargetPointer setTargetPointer;

    public PutCardIntoGraveFromAnywhereAllTriggeredAbility(Effect effect, boolean optional, TargetController targetController) {
        this(effect, optional, StaticFilters.FILTER_CARD_A, targetController);
    }

    public PutCardIntoGraveFromAnywhereAllTriggeredAbility(Effect effect, boolean optional, FilterCard filter, TargetController targetController) {
        this(effect, optional, filter, targetController, SetTargetPointer.NONE);
    }

    public PutCardIntoGraveFromAnywhereAllTriggeredAbility(Effect effect, boolean optional, FilterCard filter, TargetController targetController, SetTargetPointer setTargetPointer) {
        this(Zone.BATTLEFIELD, effect, optional, filter, targetController, setTargetPointer);
    }

    public PutCardIntoGraveFromAnywhereAllTriggeredAbility(Zone zone, Effect effect, boolean optional, FilterCard filter, TargetController targetController, SetTargetPointer setTargetPointer) {
        super(zone, effect, optional);
        this.filter = filter.copy();
        this.setTargetPointer = setTargetPointer;
        this.filter.add(targetController.getOwnerPredicate());
        StringBuilder sb = new StringBuilder(this.getWhen());
        sb.append(filter.getMessage());
        sb.append(filter.getMessage().startsWith("one or more") ? " are" : " is");
        sb.append(" put into ");
        switch (targetController) {
            case OPPONENT: {
                sb.append("an opponent's");
                break;
            }
            case YOU: {
                sb.append("your");
                break;
            }
            default: {
                sb.append('a');
            }
        }
        sb.append(" graveyard from anywhere, ");
        this.setTriggerPhrase(sb.toString());
    }

    protected PutCardIntoGraveFromAnywhereAllTriggeredAbility(PutCardIntoGraveFromAnywhereAllTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public PutCardIntoGraveFromAnywhereAllTriggeredAbility copy() {
        return new PutCardIntoGraveFromAnywhereAllTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (((ZoneChangeEvent)event).getToZone() != Zone.GRAVEYARD || !this.zone.match(game.getState().getZone(this.getSourceId()))) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        if (card == null || card.isCopy() || !this.filter.match(card, this.getControllerId(), this, game)) {
            return false;
        }
        switch (this.setTargetPointer) {
            case CARD: {
                this.getEffects().setTargetPointer(new FixedTarget(card, game));
                break;
            }
            case PLAYER: {
                this.getEffects().setTargetPointer(new FixedTarget(card.getOwnerId(), 0));
            }
        }
        return true;
    }
}

