/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class RenewEffect
extends OneShotEffect {
    private final List<Counter> counters = new ArrayList<Counter>();

    RenewEffect(Counter ... counters) {
        super(Outcome.Benefit);
        for (Counter counter : counters) {
            this.counters.add(counter);
        }
        this.staticText = RenewEffect.makeText(this.counters);
    }

    private RenewEffect(RenewEffect effect) {
        super(effect);
        for (Counter counter : effect.counters) {
            this.counters.add(counter.copy());
        }
    }

    @Override
    public RenewEffect copy() {
        return new RenewEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        for (Counter counter : this.counters) {
            permanent.addCounters(counter, source, game);
        }
        return true;
    }

    private static String makeText(List<Counter> counters) {
        return "put " + CardUtil.concatWithAnd(counters.stream().map(Counter::getDescription).collect(Collectors.toList())) + " on target creature";
    }
}

