/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.delayed.AtTheBeginOfNextCleanupDelayedTriggeredAbility;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

public class SacrificeIfCastAtInstantTimeTriggeredAbility
extends TriggeredAbilityImpl {
    public SacrificeIfCastAtInstantTimeTriggeredAbility() {
        super(Zone.STACK, new CreateDelayedTriggeredAbilityEffect(new AtTheBeginOfNextCleanupDelayedTriggeredAbility(new SacrificeSourceEffect(true))));
    }

    protected SacrificeIfCastAtInstantTimeTriggeredAbility(SacrificeIfCastAtInstantTimeTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public SacrificeIfCastAtInstantTimeTriggeredAbility copy() {
        return new SacrificeIfCastAtInstantTimeTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !spell.getSourceId().equals(this.getSourceId())) {
            return false;
        }
        if (Boolean.TRUE.equals(game.getState().getValue("PlayFromNotOwnHandZone" + this.getSourceId()))) {
            return false;
        }
        return !game.isMainPhase() || !game.isActivePlayer(event.getPlayerId()) || game.getStack().size() != 1;
    }

    @Override
    public String getRule() {
        return "If you cast it any time a sorcery couldn't have been cast, the controller of the permanent it becomes sacrifices it at the beginning of the next cleanup step.";
    }
}

