/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.SacrificedPermanentBatchEvent;
import mage.game.events.SacrificedPermanentEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;

public class SacrificeOneOrMorePermanentsTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<SacrificedPermanentEvent> {
    private final FilterPermanent filter;
    private final SetTargetPointer setTargetPointer;
    private final TargetController sacrificingPlayer;

    public SacrificeOneOrMorePermanentsTriggeredAbility(Effect effect, FilterPermanent filter) {
        this(Zone.BATTLEFIELD, effect, filter, TargetController.YOU, SetTargetPointer.NONE, false);
    }

    public SacrificeOneOrMorePermanentsTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, TargetController sacrificingPlayer, SetTargetPointer setTargetPointer, boolean optional) {
        super(zone, effect, optional);
        if (Zone.BATTLEFIELD.match(zone)) {
            this.setLeavesTheBattlefieldTrigger(true);
        }
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.sacrificingPlayer = sacrificingPlayer;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    protected SacrificeOneOrMorePermanentsTriggeredAbility(SacrificeOneOrMorePermanentsTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.setTargetPointer = ability.setTargetPointer;
        this.sacrificingPlayer = ability.sacrificingPlayer;
    }

    @Override
    public SacrificeOneOrMorePermanentsTriggeredAbility copy() {
        return new SacrificeOneOrMorePermanentsTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SACRIFICED_PERMANENT_BATCH;
    }

    @Override
    public boolean checkEvent(SacrificedPermanentEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null || !this.filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        switch (this.sacrificingPlayer) {
            case YOU: {
                return this.isControlledBy(event.getPlayerId());
            }
            case OPPONENT: {
                return game.getOpponents(this.getControllerId()).contains(event.getPlayerId());
            }
            case ANY: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported TargetController in SacrificePermanentTriggeredAbility: " + (Object)((Object)this.sacrificingPlayer));
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        List matchingPermanents = this.getFilteredEvents((SacrificedPermanentBatchEvent)event, game).stream().map(GameEvent::getTargetId).map(game::getPermanentOrLKIBattlefield).filter(Objects::nonNull).collect(Collectors.toList());
        if (matchingPermanents.isEmpty()) {
            return false;
        }
        this.getEffects().setValue("sacrificedPermanents", matchingPermanents);
        switch (this.setTargetPointer) {
            case PERMANENT: {
                this.getEffects().setTargetPointer(new FixedTargets(matchingPermanents, game));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SetTargetPointer in SacrificePermanentTriggeredAbility: " + (Object)((Object)this.setTargetPointer));
            }
        }
        return true;
    }

    private String generateTriggerPhrase() {
        String targetControllerText;
        switch (this.sacrificingPlayer) {
            case YOU: {
                targetControllerText = "you sacrifice one or more ";
                break;
            }
            case OPPONENT: {
                targetControllerText = "an opponent sacrifices one or more ";
                break;
            }
            case ANY: {
                targetControllerText = "one or more players sacrifice one or more ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported TargetController in SacrificePermanentTriggeredAbility: " + (Object)((Object)this.sacrificingPlayer));
            }
        }
        return this.getWhen() + targetControllerText + this.filter.getMessage() + ", ";
    }
}

