/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.SiegeDefeatedEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SiegeDefeatedTriggeredAbility
extends TriggeredAbilityImpl {
    SiegeDefeatedTriggeredAbility() {
        super(Zone.BATTLEFIELD, new SiegeDefeatedEffect(), true);
        this.setRuleVisible(false);
    }

    private SiegeDefeatedTriggeredAbility(SiegeDefeatedTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public SiegeDefeatedTriggeredAbility copy() {
        return new SiegeDefeatedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_REMOVED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = this.getSourcePermanentOrLKI(game);
        return permanent != null && permanent.getCounters(game).getCount(CounterType.DEFENSE) == 0 && event.getTargetId().equals(this.getSourceId()) && event.getData().equals(CounterType.DEFENSE.getName()) && event.getAmount() > 0;
    }

    @Override
    public String getRule() {
        return "When the last defense counter is removed from this permanent, exile it, then you may cast it transformed without paying its mana cost.";
    }
}

