/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterSpell;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;

public class SpellCastOpponentTriggeredAbility
extends TriggeredAbilityImpl {
    protected FilterSpell filter;
    protected SetTargetPointer setTargetPointer;
    private final boolean onlyFromNonHand;

    public SpellCastOpponentTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, false);
    }

    public SpellCastOpponentTriggeredAbility(Effect effect, boolean optional, boolean onlyFromNonHand) {
        this(effect, StaticFilters.FILTER_SPELL_A, optional, onlyFromNonHand);
    }

    public SpellCastOpponentTriggeredAbility(Effect effect, FilterSpell filter, boolean optional) {
        this(effect, filter, optional, false);
    }

    public SpellCastOpponentTriggeredAbility(Effect effect, FilterSpell filter, boolean optional, boolean onlyFromNonHand) {
        this(Zone.BATTLEFIELD, effect, filter, optional, onlyFromNonHand);
    }

    public SpellCastOpponentTriggeredAbility(Zone zone, Effect effect, FilterSpell filter, boolean optional) {
        this(zone, effect, filter, optional, false);
    }

    public SpellCastOpponentTriggeredAbility(Zone zone, Effect effect, FilterSpell filter, boolean optional, boolean onlyFromNonHand) {
        this(zone, effect, filter, optional, SetTargetPointer.NONE, onlyFromNonHand);
    }

    public SpellCastOpponentTriggeredAbility(Zone zone, Effect effect, FilterSpell filter, boolean optional, SetTargetPointer setTargetPointer) {
        this(zone, effect, filter, optional, setTargetPointer, false);
    }

    public SpellCastOpponentTriggeredAbility(Zone zone, Effect effect, FilterSpell filter, boolean optional, SetTargetPointer setTargetPointer, boolean onlyFromNonHand) {
        super(zone, effect, optional);
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.onlyFromNonHand = onlyFromNonHand;
        this.setTriggerPhrase(this.getWhen() + "an opponent casts " + filter.getMessage() + (onlyFromNonHand ? " from anywhere other than their hand" : "") + ", ");
    }

    protected SpellCastOpponentTriggeredAbility(SpellCastOpponentTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.setTargetPointer = ability.setTargetPointer;
        this.onlyFromNonHand = ability.onlyFromNonHand;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getPlayer(this.getControllerId()).hasOpponent(event.getPlayerId(), game)) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (!this.filter.match(spell, this.getControllerId(), this, game)) {
            return false;
        }
        if (this.onlyFromNonHand && spell.getFromZone() == Zone.HAND) {
            return false;
        }
        this.getEffects().setValue("spellCast", spell);
        switch (this.setTargetPointer) {
            case NONE: {
                break;
            }
            case SPELL: {
                this.getEffects().setTargetPointer(new FixedTarget(event.getTargetId()));
                break;
            }
            case PLAYER: {
                this.getEffects().setTargetPointer(new FixedTarget(event.getPlayerId()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Value of SetTargetPointer not supported!");
            }
        }
        return true;
    }

    @Override
    public SpellCastOpponentTriggeredAbility copy() {
        return new SpellCastOpponentTriggeredAbility(this);
    }
}

