/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;

public class TurnedFaceUpSourceTriggeredAbility
extends TriggeredAbilityImpl {
    private final boolean setTargetPointer;

    public TurnedFaceUpSourceTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public TurnedFaceUpSourceTriggeredAbility(Effect effect, boolean setTargetPointer) {
        this(effect, setTargetPointer, false);
    }

    public TurnedFaceUpSourceTriggeredAbility(Effect effect, boolean setTargetPointer, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setWorksFaceDown(true);
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("When {this} is turned face up, ");
        this.withRuleTextReplacement(true);
    }

    protected TurnedFaceUpSourceTriggeredAbility(TurnedFaceUpSourceTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public TurnedFaceUpSourceTriggeredAbility copy() {
        return new TurnedFaceUpSourceTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TURNED_FACE_UP;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getSourceId())) {
            if (this.setTargetPointer) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer(new FixedTarget(event.getTargetId(), game));
                }
            }
            return true;
        }
        return false;
    }
}

