/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class WasCastFromExileWatcher
extends Watcher {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    WasCastFromExileWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST || !Zone.EXILED.match(event.getZone())) {
            return;
        }
        Spell spell = game.getSpell(event.getSourceId());
        if (spell != null) {
            this.morSet.add(new MageObjectReference(spell.getMainCard(), game, -1));
        }
    }

    static boolean check(MageObjectReference mor, Game game) {
        return game.getState().getWatcher(WasCastFromExileWatcher.class).morSet.contains(mor);
    }
}

